function [vert_img] = plot_verts(verts,varargin)
%A function to plot back in space a set of vertices.  The original
%plot_vert was a little too ambitious?! *really?*  Anyway, this version is
%simpler and dumber, which means it should work.
%Synatax:   [vert_img] = plot_verts(vert,'size',[x y z],'dilate',5); 
%Input:     verts = a list of the vm nertices
%           size = the size of the image stack, by default the image size
%               the largest x, the largest y, and the largest z in the vert
%               data set.
%           dillate = dilate as a circle the image.  Default  = no
%           dilation.
%           sav = 1(default) or 0.  1 = save as tiff.  0 = do not save.
%           Default: puncta size is set at 1px, with max intensity of a
%           uint16 image.  
%Output:    vert_img = the image matrix of the ploted vertices.
%           the images will also be saved to files in a directory you
%           specify.

[imdim,sav,dil] = parse(varargin,verts);

%now create the matrix for the image volumn first
vert_img = zeros(imdim,'uint16');

%to plot the vertices, we need to bring it into pixel cooridnates
verts = round(verts);
verts(verts==0) = 1;  %no zeros in pixel land

%convert verts into linear indexes
idx = size(vert_img,1).*(verts(:,2)-1)+verts(:,1)+(size(vert_img,1)*size(vert_img,2)).*(verts(:,3)-1);

%plot in the vertices
vert_img(idx) = intmax('uint16');  %set to max

%dilate
if ~isempty(dil)    %not empty dilate
    se = strel('disk',dil);
    vert_img = imdilate(vert_img,se);
end

%open dialogue box for saving the files if you want the images saved.
if sav
    [filename,pathname,filterindex] = uiputfile2('.tif');       %get the directory and the filenames
    stk2tiff(vert_img,filename,pathname);  %save the images
end

%--------------------------------------------------------------------------
%subfunction to parse the inputs.
function [imdim,sav,dil] = parse(input,vert)

imdim = [];
sav = 1;
dil = [];

%Parse the input
if ~isempty(input)
    for i = 1:2:size(input,2)
        if ischar(input{1,i});
            switch input{1,i}
                case 'size'
                    imdim = input{1,i+1};
                case 'sav'
                    sav = input{1,i+1};
                case 'dilate'
                    dil = input{1,i+1};
                otherwise
                    warning(['Your input ',input{1,i},' is not recognized.']);
            end
        else
            error(['The parameters you entered is incorrect.  Please check help.']);
        end
    end
end

%if size is not explicit, define size.
if isempty(imdim)
    imdim = ceil(max(vert));
end